<?php
header("Content-Type: application/json");
require_once 'db.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $data = json_decode(file_get_contents('php://input'), true);
    $pass_id = intval($data['pass_id']);
    
    // Generate 8-digit OTP
    $otp_code = str_pad(mt_rand(0, 99999999), 8, '0', STR_PAD_LEFT);
    $current_date = date('Y-m-d H:i:s');
    
    // Update status and OTP
    $sql = "UPDATE visitors_gate_pass 
            SET status = 2, otp_code = '$otp_code', apprived_date = '$current_date' 
            WHERE pass_id = $pass_id";
    
    if ($conn->query($sql) === TRUE) {
        // Get visitor email
        $email_sql = "SELECT visitors_email FROM visitors_gate_pass WHERE pass_id = $pass_id";
        $email_result = $conn->query($email_sql);
        $row = $email_result->fetch_assoc();
        $visitor_email = $row['visitors_email'];
        
        // Send email (replace with your actual email credentials)
        $to = $visitor_email;
        $subject = "Your Gate Pass OTP";
        $message = "Your OTP code for gate entry is: $otp_code";
        $headers = "From: gatepass@yourcompany.com" . "\r\n";
        
        // For actual implementation, you might want to use PHPMailer or similar
        $mail_sent = mail($to, $subject, $message, $headers);
        
        if ($mail_sent) {
            echo json_encode([
                'status' => 'success',
                'message' => 'Visitor approved and OTP sent',
                'otp_code' => $otp_code
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'message' => 'Visitor approved but email sending failed'
            ]);
        }
    } else {
        echo json_encode([
            'status' => 'error',
            'message' => 'Error approving visitor: ' . $conn->error
        ]);
    }
} else {
    echo json_encode([
        'status' => 'error',
        'message' => 'Invalid request method'
    ]);
}

$conn->close();
?>